/******************************************************************************
                                                   COPYRIGHT (c) FREESCALE 2005  
File Name          :    $RCSfile: S12XMPUV1.h,v $                    
                                                                          
Current Revision :      $Revision: 1.0 $                                  
                                                                          
PURPOSE: header file for HCS12XE Memory Protection Unit (MPU) 
         control registers block           
                                                                          
DESCRIPTION:  Defines the MPU control registers block as a datastructure
              of type tMPU.     
              Contains descriptor register formats, bit masks and Macros 
              for two alternative data formats that can be switched by 
              commenting out the define of EASY_TO_READ_DESCRIPTORS below.
                                                      
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR       DATE       DESCRIPTION OF CHANGE                        
---  ------      --------    ---------------------                        
1.0  r32151      08/09/05    - Initial coding     
2.0  r32151      26/01/06    - removed alternative MPU layout

     *******************************************************************
     * File created by: Freescale East Kilbride MCD Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/
    
                                                                          
/* This header file needs to be compiled with option "-BfaGapLimitBits-1" !!! */
/* This is to force the compiler to use bits from LSB of words rather than LSB of bytes */
/* if the option is not used, the compiler will start using the upper byte of a word first */
/* i.e. starting from the MIDDLE of the register ! */


#ifndef S12XMPU_H         /*prevent duplicated includes */
#define S12XMPU_H

#include "S12_COMMON.h"

typedef union uMPUFLG
  {
  tU08   byte;
  struct
    {
    tU08 svsf   :1;   /*supervisor state flag */
    tU08        :4;                      
    tU08 nexf   :1;   /*no execute violation flag */
    tU08 wpf    :1;   /*write protect violation flag */
    tU08 aef    :1;   /*access error flag */
    }bit;
  }tMPUFLG;

/* bit masks for MPUFLG */
#define SVSF 0x01   
#define NEXF 0x20
#define WPF  0x40
#define AEF  0x80

typedef union uMPUSTAT
  {
  void *far ptr;
  struct
    {
    tU08 page;     /*supervisor state flag */
    tU16 addr;
    }part;
  }tMPUSTAT;

typedef union uMPUSEL
  {
  tU08   byte;
  struct
    {
    tU08 sel    :3;   /*descriptor index bits */
    tU08        :4;                      
    tU08 svsen  :1;  /*supervisor protection enable */
    }bit;
  }tMPUSEL;

/* bit masks for MPUSEL */
#define MPU_SEL_MASK 0x07 /*mpu select mask */
#define SVSEN        0x80

typedef struct
   {
      tU16   _12;
      tU16   _34;
      tU16   _56;
  }tMPUDESC;

#define MSTR0 BIT7
#define MSTR1 BIT6
#define MSTR2 BIT5
#define MSTR3 BIT4

#define M_CPU_SS MSTR0
#define M_CPU_US MSTR1
#define M_XGATE  MSTR2
#define M_3      MSTR3

#define WP  BIT7
#define NEX BIT6

#define WR_OK  0x00
#define WR_ERR WP
#define EX_OK  0x00
#define EX_ERR NEX
#define DESC_INDEX_MASK 0x07


typedef struct                /*MPU datastructure */
  {
  volatile tMPUFLG  mpuflg;            /*error flags */
  volatile tMPUSTAT mpustat;           /*error access address */
  volatile tU08     rsv;   				/*reserved byte*/
  volatile tMPUSEL  mpusel;            /*descriptor index */
  volatile tMPUDESC desc;              /*descriptor registers */

  }tMPU;


#endif /*S12XMPU_H */